import { Subject } from "rxjs";
import { IActionParam, IParam } from '@ibiz-core';
/**
 * 视图基类状态
 */
export interface ViewStateBase {
  /**
   * 视图名称
   */
  viewName: string;

  /**
   * 视图代码名称
   */
  viewCodeName: string;

  /**
   * 上下文参数
   */
  context: IParam;

  /**
   * 视图参数
   */
  viewParams: IParam;

  /**
   * 视图参数(外部传入)
   */
  viewSubject: Subject<IActionParam>;

  // 声明任意属性
  [propName: string]: any;
}
